/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.infection;

import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingConversionEvent;
import net.minecraftforge.eventbus.api.Event;

public class InfectionConversionEntry {
    protected final int infectChance;
    protected final EntityType<? extends LivingEntity> result;
    protected CompoundNBT nbt = null;

    protected InfectionConversionEntry(int infectChance, EntityType<? extends LivingEntity> result) {
        this.infectChance = infectChance;
        this.result = result;
    }

    public LivingEntity convertEntity(LivingEntity entity) {
        LivingConversionEvent.Pre preEvent = new LivingConversionEvent.Pre(entity, this.result, i -> {});
        MinecraftForge.EVENT_BUS.post((Event)preEvent);
        World world = entity.field_70170_p;
        LivingEntity zombie = (LivingEntity)preEvent.getOutcome().func_200721_a(world);
        zombie.func_70107_b(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            zombie.func_184201_a(slot, entity.func_184582_a(slot));
        }
        if (entity.func_145818_k_()) {
            zombie.func_200203_b(entity.func_200201_e());
        }
        if (zombie instanceof AgeableEntity) {
            ((AgeableEntity)zombie).func_70873_a(entity.func_70631_g_() ? -1000000 : 0);
        }
        if (zombie instanceof ZombieEntity) {
            ((ZombieEntity)zombie).func_82227_f(entity.func_70631_g_());
        }
        if (this.nbt != null) {
            entity.func_70037_a(this.nbt);
        }
        LivingConversionEvent.Post postEvent = new LivingConversionEvent.Post(entity, zombie);
        MinecraftForge.EVENT_BUS.post((Event)postEvent);
        zombie = postEvent.getOutcome();
        world.func_217376_c((Entity)zombie);
        entity.func_174812_G();
        return zombie;
    }

    public int getInfectChance() {
        return this.infectChance;
    }

    public void setNBT(CompoundNBT nbt) {
        this.nbt = nbt;
    }
}

